(function($) {
//******************************************************************
// document loaded functions
//******************************************************************/


var isTouch = (('ontouchstart' in window) || (navigator.msMaxTouchPoints > 0));
/*
//******************************************************************
//  menu toggle button actions
//******************************************************************/

function initNavToggle() {
	$('.menu-toggle').on('click', function(e){
			e.preventDefault();
			$('.menu-toggle').toggleClass('menu-open');
			$('.main-nav .level0').toggleClass('menu-open');
		});

// toggle on main menu on small devices

		$('.main-nav .sub-toggle').on('click', function(e){
			e.preventDefault();
			$(this).toggleClass('menu-open');
			$(this).siblings('.dropmenu').toggleClass('menu-open');
			$(this).siblings('.submenu').toggleClass('menu-open');
		});

// toggle on submenus on mobile

		$('.mobile-toggle').on('click', function(e){
			e.preventDefault();
		  $(this).toggleClass('menu-open');
			$(this).siblings('ul').toggleClass('menu-open');
		});

}

/*
//******************************************************************
//  sliders
//******************************************************************/

function initSlider() {
	$("#owl-slider").owlCarousel({
		items:1,
		loop: true,
		dots:true,
		autoplay:true,
    autoplayTimeout:15000,
		nav:true,
		navText: [
      "<i class='fa fa-chevron-left' aria-hidden='true'></i>",
      "<i class='fa fa-chevron-right' aria-hidden='true'></i>"
      ],
	});
}


/*
//******************************************************************
//  drop down menus from main nav
//******************************************************************/

function addMega(){
	 var item = $(this);
	 if (!isTouch) {
		  if (!item.hasClass("hovering")) {
			  item.addClass("hovering");
				item.children("ul").addClass("active");
		  }
	 }
}

function removeMega(){
  $('.level0 > li').removeClass("hovering");
 }
  //Set custom configurations

function initDropMenu() {
	var megaConfig = {
	    sensitivity: 2, // number = sensitivity threshold (must be 1 or higher)
	    interval: 60, // number = milliseconds for onMouseOver polling interval
	    over: addMega, // function = onMouseOver callback (REQUIRED)
	    timeout: 60, // number = milliseconds delay before onMouseOut
	    out: removeMega // function = onMouseOut callback (REQUIRED)
	};

	$(".level0 > li").hoverIntent(megaConfig);
}


//******************************************************************
//  Accordion div's Show Hide
//******************************************************************/

function initAccordion() {
 $('.ac-prompt').bind('click', function() {
			var row = $(this).parent('.accordion-row');
			var height = $(".ac-content .content-wrapper", row).height();
			row.toggleClass("open");
			$(this).toggleClass("open");
			if (row.hasClass("open")) {
				$(".ac-content", row).css("max-height", height + 20);
			}
			else {
				$(".ac-content", row).css("max-height", 0);
			}
});

}

//******************************************************************
//  Profile div's Show Hide
//******************************************************************/
/*
function initProfile() {

	$('.profile-thumb').on('click', function(e) {
				var itemWidth = $(".pro-item").outerWidth(); // width with padding
				var padWidth = itemWidth - $('.pro-item').width();
				var position = $(this).position();
				// determine position to move the toggled bio to the left so it is full
				// width under the row of current profile images. Give it a class we can stle against based on it's column.
				var columnCount = Math.round(position.left/itemWidth) + 1;
				var row = $(this).parent('.pro-item');
				if (row.hasClass('pro-open')) {
					close_profile_section();
				} else {
					close_profile_section();
					$(this).toggleClass("active");
					var rightPos = (columnCount-1)*itemWidth + padWidth/2;
					$(this).next('.pro-bio').css( "width", getGridWidth() );
					$(this).next('.pro-bio').css( "right", rightPos+"px");
					$(this).next('.pro-bio').slideDown(600);
					row.addClass('pro-open');
				}
				// get rid of old column classes incase screen was resized
				e.preventDefault();
	});
	$('.pro-close').on('click', function(e) {
			close_profile_section();
	});

} */





//******************************************************************
// Open external links in new window
//******************************************************************/
function initSettings() {
	$("a[href*='http://'], a[href*='https://']").not("[href*='"+location.hostname.replace("www.","")+"']").each(function() {
		jQuery(this).on('click', function(event) {
		  event.preventDefault();
			event.stopPropagation();
			window.open(this.href, '_blank');
			}).addClass('externalLink');
	});
}



//******************************************************************
// For the Search form
//******************************************************************/

	$(".ags-search-choice .s1").on('change', function() {
		var checkVal;
			checkVal = $(".ags-search-choice :radio[name='s1']:checked").val();
	    if (checkVal === '1') {
	        $(".ags-search-form").attr("action","/search/ags");
	    }
	    else if (checkVal === '2') {
	       $(".ags-search-form").attr("action","/search/ags-sites");
	    }
	    // save the last choice in local storage and we'll use it when we display the search form again
	    localStorage.setItem('searchradio', checkVal);
});

	//******************************************************************
	//  Search block
	//******************************************************************/
	$(".search-btn").on('click',function () {
		if (!$(".search-block-form").hasClass("open")) {
			$(".search-block-form").addClass("open");
		} else {
	   $(".search-block-form").removeClass("open");
	  }
	});
	$(".search-submit").on('click',function () {
	   $(".search-block-form").removeClass("open");
	});
	$(".search-close").on('click', function () {
	   $(".search-block-form").removeClass("open");
});


function initRadio() {
		var setVal;
		if (localStorage.getItem('searchradio')) {
			setVal = localStorage.getItem('searchradio');
		}
		else {
			setVal = '1';
		}
		$('input:radio[name=s1][value=' + setVal + ']').click(); // initialize search radio button$
}

//
// iPads don't hover...
//

function initTouch() {

// 	when on an ipad, hover won't work, so turn it off, and use a click function to activate breadcrumb menus
// crumb-toggle is only displayed on large screens.  On smallerscreens there is a click event on mobile-toggle above.
	if(isTouch) {
			$('[hover="on"]').attr("hover", "off");
			$('.crumb-down .drop-down .crumb-toggle').on('click touch', function(event) {
				var dropdown = $(this).parent();
				$('.crumb-down .drop-down').not(dropdown).removeClass('open');	// close other open crumb menus
				$(dropdown).toggleClass('open');
			});
	}
	else {
		$('[hover="off"]').attr("hover", "on");

	}

}

//
// Scroll to Top feature
//

function scrollTop () {
   $("#back-top").hide();
   $(window).scroll(function () {
      if ($(this).scrollTop() > 100) {
        $('#back-top').fadeIn();
      } else {
        $('#back-top').fadeOut();
      }
    });

    // scroll body to 0px on click
    $('#back-top').on('click',function () {
      $('body,html').animate({
        scrollTop: 0
      }, 800);
      return false;
    });
}

$(window).on('changed.zf.mediaquery', function(event, newSize, oldSize) {
	close_profile_section();
  // newSize is the name of the now-current breakpoint, oldSize is the previous breakpoint
	if (newSize != 'large') {
		// don't display the main menu unless large. Otherwize it's triggered by button
	}

  if (newSize !== 'medium' && newSize !== 'small') {
  	$('.main-nav *').removeClass('menu-open');
  }
  if (newSize !== 'small') {
	  $('.crumb-down *').removeClass('menu-open');
  }

});

/* Using Drupal behaviors here because we're loading more profiles using AJAX. Because they aren't
* all loaded at initial page load, we have to make sure to set a click event on the new items.
* Drupal behaviors will do this. Use "context" to make sure the behaviors are only set up onces per item.
*/
(function (Drupal, $, once) {
  Drupal.behaviors.attachProfile = {
    attach: function (context, settings) {
      $(once("bind-click-event", ".profile-thumb", context)).each(function (e) {
        $(this).on("click", function (e) {
          e.preventDefault();
          close_profile_section();
          var itemWidth = $(".pro-item").outerWidth(); // width with padding
          var itemHeight = $(".pro-item").height();
          var padWidth = itemWidth - $(".pro-item").width();
          var position = $(this).position();
          // determine position to move the toggled bio to the left so it is full
          // width under the row of current profile images. Give it a class we can style against based on it's column.
          var columnCount = Math.round(position.left / itemWidth) + 1;
          var row = $(this).parent(".pro-item");
          var masterRow = row.parent(".profile-grid");
          $(this).toggleClass("active");
          var rightPos = (columnCount - 1) * itemWidth + padWidth / 2;
          bioID = $(this).next(".pro-bio");
          bioID.addClass("currentBio");
          bioID.css("width", getGridWidth());
          bioID.css("right", rightPos + "px");
          //bioID.slideDown(600);
          row.addClass("pro-open");
          var topOffset = $(this).offset().top;
          setTimeout(function () {
            window.scroll({
              top: topOffset,
              left: 0,
              behavior: "smooth",
            });
          }, 100);
        });
      });
      $(once("bind-click-event", ".pro-close", context)).each(function (e) {
        $(this).on("click", function (e) {
          close_profile_section();
        });
      });
    },
  };
})(Drupal, jQuery, once);
function close_profile_section() {
  $(".pro-item .profile-thumb").removeClass("active");
  //$(".pro-item .pro-bio").slideUp(300);
  $(".pro-item").removeClass("pro-open");
	$(".pro-bio").removeClass("currentBio");
}

function getGridWidth() {
  // calculate how many items are across in the grid.
  /*
	var itemWidth = $(".pro-item").outerWidth();
	var gridWidth = itemWidth;
	var loopCount = 0;
	$(".pro-item").each(function() {
		var position = $(this).position();
		loopCount += 1;
		if (position.left == 0 && loopCount > 1) {
      return false;
		}
		else {
			gridWidth = loopCount * itemWidth;
		}
	});
	return gridWidth;
*/
  return $(".profile-grid").outerWidth();
}

$(document).ready(function() {
	initSettings();
	close_profile_section();
	scrollTop();
	initTouch();
	initDropMenu();
	initNavToggle();
	initRadio();
	initAccordion();
	//initProfile();
	initSlider();


});

}(jQuery));


